/* @(#) somx/sample4p.cpp 2.4 2/25/94 10:57:55 [5/15/94 17:59:16] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*
 *  Persistent Framework - Example Program 4
 */

#include <stdlib.h>
#include <somp.xh>               /*  Persistence Includes   */

#include <direntry.xh>           /*  Client Class Includes */
#include <phonedir.xh>

#include <dired.xh>              /*  Includes for application-supplied */
#include <entryed.xh>            /*  encoder/decoders.                 */

/* Globals.
   -------- */
SOMClass *diredClass, *entryedClass;
SOMPPersistentStorageMgr *psm;
static char idBuff[SOMPMAXIDSIZE]; /*  Stores system Id of persistent object */
Environment *ev;

/*
--------------------------------------------------------------------
save
Demonstrates creating and storing of a compound
persistent object - a list of phone numbers.

Demonstrated Features:
  - client-assigned persistent id.
  - all objects in a single io/group.
  - client-supplied encoder/decoder.
--------------------------------------------------------------------
*/

void save()
{
/* Local declarations.
   ------------------- */
   SOMPPersistentId *pid;
   dirEntry  *name1, *name2;
   phoneDir  *mylist;
   string    fp;

/* Create the persistent objects.
   ------------------------------ */
   mylist = new phoneDir;
   name1  = new dirEntry;
   name2  = new dirEntry;

/* Set the encoder/decoder class.
   This call sets for only "mylist" object.
   ------------------------------------------------------- */
   mylist->sompSetEncoderDecoderName (ev, "dirED");

/* Set the encoder/decoder class.
   This call sets for all objects of class "dirEntry"
   ------------------------------------------------------- */
   ((M_SOMPPersistentObject*)(name1->somGetClass()))->sompSetClassLevelEncoderDecoderName(ev, "entryED");

/* Create the persistent Id.
   ------------------------- */
   pid = new SOMPPersistentId;
   pid->sompSetIOGroupName(ev, "./phoneDir");
   if (ev->_major != NO_EXCEPTION) exit(-1);
   mylist->sompInitGivenId (ev, pid);
   delete pid;
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Get the object id used for storing the directory.
   ------------------------------------------------- */
   pid = mylist->sompGetPersistentId (ev);
   fp  = pid->sompGetIOGroupName (ev, idBuff);

/* Add entry 1.
   ------------ */
   name1->mkEntry ("Roger", "555-5085");
   name1->sompInitNearObject (ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);
   mylist->addEntry (name1);

/* Add entry 2.
   ------------ */
   name2->mkEntry ("Robert", "555-8151");
   name2->sompInitNearObject (ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);
   mylist->addEntry (name2);

/* Display phone directory.
   ------------------------ */
   mylist->printDirInfo();

/* Store the phone directory.
   -------------------------- */
   psm->sompStoreObject (ev, mylist);
   if (ev->_major != NO_EXCEPTION) {
      printf ("\nBack from StoreObject - ERROR!\n");
   } else {
      printf ("\nBack from StoreObject - Ok\n");
      printf ("Group Name is %s\n", idBuff);
   }

/* Finished.
   --------- */
   delete name2;
   delete name1;
   delete mylist;
}

/*
--------------------------------------------------------------------
restore
Demonstrates restoring a (previously created) compound
persistent object - a list of phone numbers.
--------------------------------------------------------------------
*/

void restore()
{
/* Local declarations.
   ------------------- */
   phoneDir  *mylist;
   SOMPPersistentId *pid;

/* Restore phone directory.
   ------------------------ */
   pid = new SOMPPersistentId;
   pid->sompSetIOGroupName(ev, idBuff);
   if (ev->_major != NO_EXCEPTION) {
      printf ("Set Persistent Name failed.\n");
      exit(-1);
   }

   mylist = (phoneDir*)psm->sompRestoreObject (ev, pid);
   if (ev->_major != NO_EXCEPTION) {
     printf ("\nRestore failed.\n");
     exit(-1);
   }

/* Display the directory.
   ---------------------- */
   mylist->printDirInfo();

/* Finished.
   --------- */
   delete pid;
   delete mylist;
}

main()
{

/* Initialize persistent framework.
   -------------------------------- */
   psm           = new SOMPPersistentStorageMgr;
   diredClass    = dirEDNewClass (0,0);
   entryedClass  = entryEDNewClass (0,0);
   ev         = somGetGlobalEnvironment();

   printf("\nSave test\n");
   save();
   printf("\nRestore test\n");
   restore();
   exit (0);

}
